﻿Public Class ConfigForm


    Const F_DATA_LEN As Integer = 7
    Const F_DATA_START As Integer = 4
    Const F_MINPWR As Integer = 0
    Const F_SENSOR As Integer = 1
    Const F_MINTEMP As Integer = 2
    Const F_MAXTEMP As Integer = 3
    Const F_CANSTOP As Integer = 4
    Const F_ATYPE As Integer = 5
    Const F_BTYPE As Integer = 6

    Const D_TYPE_FAN_1 As Integer = F_DATA_START + (0 * F_DATA_LEN)
    Const D_TYPE_FAN_2 As Integer = F_DATA_START + (1 * F_DATA_LEN)
    Const D_TYPE_FAN_3 As Integer = F_DATA_START + (2 * F_DATA_LEN)
    Const D_TYPE_FAN_4 As Integer = F_DATA_START + (3 * F_DATA_LEN)



    Private Sub Apply_Click_1(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Apply.Click
        If Not ValidityCheck() Then Exit Sub
        ApplyChanges()
    End Sub

    Private Sub OK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles OK.Click
        If Not ValidityCheck() Then Exit Sub
        ApplyChanges()
        Me.Close()
    End Sub


    Private Sub ApplyChanges()

        Dim i As Integer
        Dim s As String

        If FanMinTemp1.SelectedIndex = -1 Then FanMinTemp1.SelectedIndex = 0
        If FanMinTemp2.SelectedIndex = -1 Then FanMinTemp2.SelectedIndex = 0
        If FanMinTemp3.SelectedIndex = -1 Then FanMinTemp3.SelectedIndex = 0
        If FanMinTemp4.SelectedIndex = -1 Then FanMinTemp4.SelectedIndex = 0

        If FanMaxTemp1.SelectedIndex = -1 Then FanMaxTemp1.SelectedIndex = 50
        If FanMaxTemp2.SelectedIndex = -1 Then FanMaxTemp2.SelectedIndex = 50
        If FanMaxTemp3.SelectedIndex = -1 Then FanMaxTemp3.SelectedIndex = 50
        If FanMaxTemp4.SelectedIndex = -1 Then FanMaxTemp4.SelectedIndex = 50

        MainForm.ConfigData(0) = SensorType1.SelectedIndex
        MainForm.ConfigData(1) = SensorType2.SelectedIndex
        MainForm.ConfigData(2) = SensorType3.SelectedIndex
        MainForm.ConfigData(3) = SensorType4.SelectedIndex

        MainForm.ConfigData(D_TYPE_FAN_1 + F_ATYPE) = FanType1.SelectedIndex
        MainForm.ConfigData(D_TYPE_FAN_1 + F_BTYPE) = FanType2.SelectedIndex
        MainForm.ConfigData(D_TYPE_FAN_2 + F_ATYPE) = FanType3.SelectedIndex
        MainForm.ConfigData(D_TYPE_FAN_2 + F_BTYPE) = FanType4.SelectedIndex
        MainForm.ConfigData(D_TYPE_FAN_3 + F_ATYPE) = FanType5.SelectedIndex
        MainForm.ConfigData(D_TYPE_FAN_3 + F_BTYPE) = FanType6.SelectedIndex
        MainForm.ConfigData(D_TYPE_FAN_4 + F_ATYPE) = FanType7.SelectedIndex
        MainForm.ConfigData(D_TYPE_FAN_4 + F_BTYPE) = FanType8.SelectedIndex

        MainForm.ConfigData(D_TYPE_FAN_1 + F_SENSOR) = FanControl1.SelectedIndex
        MainForm.ConfigData(D_TYPE_FAN_2 + F_SENSOR) = FanControl2.SelectedIndex
        MainForm.ConfigData(D_TYPE_FAN_3 + F_SENSOR) = FanControl3.SelectedIndex
        MainForm.ConfigData(D_TYPE_FAN_4 + F_SENSOR) = FanControl4.SelectedIndex

        MainForm.ConfigData(D_TYPE_FAN_1 + F_MINPWR) = FanMinSpeed1.SelectedIndex * 5
        MainForm.ConfigData(D_TYPE_FAN_2 + F_MINPWR) = FanMinSpeed2.SelectedIndex * 5
        MainForm.ConfigData(D_TYPE_FAN_3 + F_MINPWR) = FanMinSpeed3.SelectedIndex * 5
        MainForm.ConfigData(D_TYPE_FAN_4 + F_MINPWR) = FanMinSpeed4.SelectedIndex * 5

        MainForm.ConfigData(D_TYPE_FAN_1 + F_MINTEMP) = FanMinTemp1.SelectedIndex * 2
        MainForm.ConfigData(D_TYPE_FAN_2 + F_MINTEMP) = FanMinTemp2.SelectedIndex * 2
        MainForm.ConfigData(D_TYPE_FAN_3 + F_MINTEMP) = FanMinTemp3.SelectedIndex * 2
        MainForm.ConfigData(D_TYPE_FAN_4 + F_MINTEMP) = FanMinTemp4.SelectedIndex * 2

        MainForm.ConfigData(D_TYPE_FAN_1 + F_MAXTEMP) = FanMaxTemp1.SelectedIndex * 2
        MainForm.ConfigData(D_TYPE_FAN_2 + F_MAXTEMP) = FanMaxTemp2.SelectedIndex * 2
        MainForm.ConfigData(D_TYPE_FAN_3 + F_MAXTEMP) = FanMaxTemp3.SelectedIndex * 2
        MainForm.ConfigData(D_TYPE_FAN_4 + F_MAXTEMP) = FanMaxTemp4.SelectedIndex * 2

        MainForm.ConfigData(D_TYPE_FAN_1 + F_CANSTOP) = If(FanAllowZero1.Checked, 1, 0)
        MainForm.ConfigData(D_TYPE_FAN_2 + F_CANSTOP) = If(FanAllowZero2.Checked, 1, 0)
        MainForm.ConfigData(D_TYPE_FAN_3 + F_CANSTOP) = If(FanAllowZero3.Checked, 1, 0)
        MainForm.ConfigData(D_TYPE_FAN_4 + F_CANSTOP) = If(FanAllowZero4.Checked, 1, 0)

        MainForm.EnableReadouts()

        s = "FCS"
        For i = 0 To F_DATA_START + (F_DATA_LEN * 4) - 1
            s = s & "," & Format(MainForm.ConfigData(i))
        Next
        MainForm.SendToCOM(s)

    End Sub

    Function ValidityCheck() As Boolean

        Dim s As String
        Dim f1 As Boolean
        Dim f2 As Boolean
        Dim f3 As Boolean
        Dim f4 As Boolean

        If FanType1.SelectedIndex <> 0 Or FanType2.SelectedIndex <> 0 Then f1 = True
        If FanType3.SelectedIndex <> 0 Or FanType4.SelectedIndex <> 0 Then f2 = True
        If FanType5.SelectedIndex <> 0 Or FanType6.SelectedIndex <> 0 Then f3 = True
        If FanType7.SelectedIndex <> 0 Or FanType8.SelectedIndex <> 0 Then f4 = True


        s = ""

        If f1 And FanControl1.SelectedIndex <> 7 And FanMaxTemp1.SelectedIndex <= FanMinTemp1.SelectedIndex Then
            s = s & "  Fans 1A and 1B: Minimum temperature must be less than maximum" & vbCrLf
        End If

        If f2 And FanControl2.SelectedIndex <> 7 And FanMaxTemp2.SelectedIndex <= FanMinTemp2.SelectedIndex Then
            s = s & "  Fans 2A and 2B: Minimum temperature must be less than maximum" & vbCrLf
        End If

        If f3 And FanControl3.SelectedIndex <> 7 And FanMaxTemp3.SelectedIndex <= FanMinTemp3.SelectedIndex Then
            s = s & "  Fans 3A and 3B: Minimum temperature must be less than maximum" & vbCrLf
        End If

        If f4 And FanControl4.SelectedIndex <> 7 And FanMaxTemp4.SelectedIndex <= FanMinTemp4.SelectedIndex Then
            s = s & "  Fans 4A and 4B: Minimum temperature must be less than maximum" & vbCrLf
        End If


        If (FanType1.SelectedIndex = 5 And (FanType2.SelectedIndex > 0 And FanType2.SelectedIndex < 5)) Or (FanType2.SelectedIndex = 5 And (FanType1.SelectedIndex > 0 And FanType1.SelectedIndex < 5)) Then
            s = s & "  Fans 1A and 1B: If one fan is 4-wire then both fans must be 4-wire" & vbCrLf
        End If

        If (FanType3.SelectedIndex = 5 And (FanType4.SelectedIndex > 0 And FanType4.SelectedIndex < 5)) Or (FanType4.SelectedIndex = 5 And (FanType3.SelectedIndex > 0 And FanType3.SelectedIndex < 5)) Then
            s = s & "  Fans 2A and 2B: If one fan is 4-wire then both fans must be 4-wire" & vbCrLf
        End If


        If SensorType1.SelectedIndex = 0 Then
            If f1 And (FanControl1.SelectedIndex = 0 Or FanControl1.SelectedIndex = 4) Then s = s & "  Fans 1A and 1B rely on sensor A which is disabled" & vbCrLf
            If f2 And (FanControl2.SelectedIndex = 0 Or FanControl2.SelectedIndex = 4) Then s = s & "  Fans 2A and 2B rely on sensor A which is disabled" & vbCrLf
            If f3 And (FanControl3.SelectedIndex = 0 Or FanControl3.SelectedIndex = 4) Then s = s & "  Fans 3A and 3B rely on sensor A which is disabled" & vbCrLf
            If f4 And (FanControl4.SelectedIndex = 0 Or FanControl4.SelectedIndex = 4) Then s = s & "  Fans 4A and 4B rely on sensor A which is disabled" & vbCrLf
        End If

        If SensorType2.SelectedIndex = 0 Then
            If f1 And (FanControl1.SelectedIndex = 1 Or FanControl1.SelectedIndex = 5) Then s = s & "  Fans 1A and 1B rely on sensor B which is disabled" & vbCrLf
            If f2 And (FanControl2.SelectedIndex = 1 Or FanControl2.SelectedIndex = 5) Then s = s & "  Fans 2A and 2B rely on sensor B which is disabled" & vbCrLf
            If f3 And (FanControl3.SelectedIndex = 1 Or FanControl3.SelectedIndex = 5) Then s = s & "  Fans 3A and 3B rely on sensor B which is disabled" & vbCrLf
            If f4 And (FanControl4.SelectedIndex = 1 Or FanControl4.SelectedIndex = 5) Then s = s & "  Fans 4A and 4B rely on sensor B which is disabled" & vbCrLf
        End If


        If SensorType3.SelectedIndex = 0 Then
            If f1 And (FanControl1.SelectedIndex = 2 Or FanControl1.SelectedIndex = 6) Then s = s & "  Fans 1A and 1B rely on sensor C which is disabled" & vbCrLf
            If f2 And (FanControl2.SelectedIndex = 2 Or FanControl2.SelectedIndex = 6) Then s = s & "  Fans 2A and 2B rely on sensor C which is disabled" & vbCrLf
            If f3 And (FanControl3.SelectedIndex = 2 Or FanControl3.SelectedIndex = 6) Then s = s & "  Fans 3A and 3B rely on sensor C which is disabled" & vbCrLf
            If f4 And (FanControl4.SelectedIndex = 2 Or FanControl4.SelectedIndex = 6) Then s = s & "  Fans 4A and 4B rely on sensor C which is disabled" & vbCrLf
        End If

        If SensorType4.SelectedIndex = 0 Then
            If f1 And (FanControl1.SelectedIndex = 3 Or (FanControl1.SelectedIndex >= 4 And FanControl1.SelectedIndex <= 6)) Then s = s & "  Fans 1A and 1B rely on sensor D which is disabled" & vbCrLf
            If f2 And (FanControl2.SelectedIndex = 3 Or (FanControl2.SelectedIndex >= 4 And FanControl2.SelectedIndex <= 6)) Then s = s & "  Fans 2A and 2B rely on sensor D which is disabled" & vbCrLf
            If f3 And (FanControl3.SelectedIndex = 3 Or (FanControl3.SelectedIndex >= 4 And FanControl3.SelectedIndex <= 6)) Then s = s & "  Fans 3A and 3B rely on sensor D which is disabled" & vbCrLf
            If f4 And (FanControl4.SelectedIndex = 3 Or (FanControl4.SelectedIndex >= 4 And FanControl4.SelectedIndex <= 6)) Then s = s & "  Fans 4A and 4B rely on sensor D which is disabled" & vbCrLf
        End If

        If s <> "" Then
            MsgBox("Error in setup:" & vbCrLf & s & vbCrLf & "Setup has not been saved.", 16, "Fan Controller")
            Return False
        Else
            Return True
        End If
    End Function

    Private Sub FanControl1_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles FanControl1.SelectedIndexChanged
        If FanControl1.SelectedIndex = 7 Then
            lblPower1.Visible = True
            lblFan1.Visible = False
            FanMinTemp1.Visible = False
            FanMaxTemp1.Visible = False
            FanAllowZero1.Checked = False
            FanAllowZero1.Visible = False
        Else
            lblPower1.Visible = False
            lblFan1.Visible = True
            FanMinTemp1.Visible = True
            FanMaxTemp1.Visible = True
            FanAllowZero1.Visible = True
        End If
    End Sub

    Private Sub FanControl2_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles FanControl2.SelectedIndexChanged
        If FanControl2.SelectedIndex = 7 Then
            lblPower2.Visible = True
            lblFan2.Visible = False
            FanMinTemp2.Visible = False
            FanMaxTemp2.Visible = False
            FanAllowZero2.Checked = False
            FanAllowZero2.Visible = False
        Else
            lblPower2.Visible = False
            lblFan2.Visible = True
            FanMinTemp2.Visible = True
            FanMaxTemp2.Visible = True
            FanAllowZero2.Visible = True
        End If
    End Sub

    Private Sub FanControl3_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles FanControl3.SelectedIndexChanged
        If FanControl3.SelectedIndex = 7 Then
            lblPower3.Visible = True
            lblFan3.Visible = False
            FanMinTemp3.Visible = False
            FanMaxTemp3.Visible = False
            FanAllowZero3.Checked = False
            FanAllowZero3.Visible = False
        Else
            lblPower3.Visible = False
            lblFan3.Visible = True
            FanMinTemp3.Visible = True
            FanMaxTemp3.Visible = True
            FanAllowZero3.Visible = True
        End If

    End Sub

    Private Sub FanControl4_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles FanControl4.SelectedIndexChanged
        If FanControl4.SelectedIndex = 7 Then
            lblPower4.Visible = True
            lblFan4.Visible = False
            FanMinTemp4.Visible = False
            FanMaxTemp4.Visible = False
            FanAllowZero4.Checked = False
            FanAllowZero4.Visible = False
        Else
            lblPower4.Visible = False
            lblFan4.Visible = True
            FanMinTemp4.Visible = True
            FanMaxTemp4.Visible = True
            FanAllowZero4.Visible = True
        End If

    End Sub
End Class

